function updateOutputSourceSelect() {
    if (cameraSettings.NdiEnable != undefined) {
        if (cameraSettings.NdiEnable == "on") {
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+ndi").text("HDMI+NDI"));
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+uvc").text("HDMI+UVC"));
        } else {
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+stream").text("HDMI+Streaming"));
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+uvc").text("HDMI+UVC"));
        }
    } else {
        $("#outputSourceSelect").append($("<option></option>").val("hdmi+stream").text("HDMI+Streaming"));
        $("#outputSourceSelect").append($("<option></option>").val("hdmi+uvc").text("HDMI+UVC"));
    }
}

function updateHdmiFormatSelect() {
    $("#hdmiFormatSelect").empty();
    $("#hdmiFormatSelect").append($("<option></option>").val("yuv422").text("YUV422"));
    if (cameraSettings.Resolution == "2160p_60" || cameraSettings.Resolution == "2160p_5994" || cameraSettings.Resolution == "2160p_50") {
        $("#hdmiFormatSelect").append($("<option></option>").val("yuv420").text("YUV420"));
    }
    $("#hdmiFormatSelect").append($("<option></option>").val("rgb").text("RGB"));
}

function updateResolution_4K_LDC_off() {
    // 4K@59 - hdmi+stream(ndi)
    // 1080i - hdmi+stream(ndi)
    // other - hdmi+stream(ndi) / hdmi+uvc
    cameraSettings.Resolution = $("#resolutionSelect").val();
    if (cameraSettings.Resolution == "2160p_5994" || cameraSettings.Resolution == "2160p_50" || cameraSettings.Resolution == "1080i_5994" || cameraSettings.Resolution == "1080i_50") {
        document.getElementById("outputSourceSelect").disabled = true;
        if ($("#outputSourceSelect").val() == "hdmi+uvc") {
            if (cameraSettings.NdiEnable == "on") {
                $("#outputSourceSelect").val("hdmi+ndi");
            } else {
                $("#outputSourceSelect").val("hdmi+stream");
            }
        }
    } else {
        document.getElementById("outputSourceSelect").disabled = false;
    }
}

function updateResolution_4K_LDC_on(supportUVC) {
    // 4K@59 - hdmi / stream / hdmi+stream
    // 1080i - hdmi+stream
    // other - hdmi+stream / hdmi+uvc
    cameraSettings.Resolution = $("#resolutionSelect").val();
    if (cameraSettings.Resolution == "2160p_60" || cameraSettings.Resolution == "2160p_5994" || cameraSettings.Resolution == "2160p_50") {
        document.getElementById("outputSourceSelect").disabled = false;
        if (document.getElementById("outputSourceSelect").options[0].value != "hdmi") {
            $("#outputSourceSelect").empty();
            $("#outputSourceSelect").append($("<option></option>").val("hdmi").text("HDMI"));
            $("#outputSourceSelect").append($("<option></option>").val("stream").text("Streaming"));
            if (cameraSettings.ModelName == "CV420e") {
                $("#outputSourceSelect").append($("<option></option>").val("hdmi+stream").text("HDMI+Streaming"));
            }
        }
    } else {
        if (supportUVC && document.getElementById("outputSourceSelect").options[1].value != "hdmi+uvc") {
            $("#outputSourceSelect").empty();
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+stream").text("HDMI+Streaming"));
            $("#outputSourceSelect").append($("<option></option>").val("hdmi+uvc").text("HDMI+UVC"));
        }
        if (cameraSettings.Resolution == "1080i_60" || cameraSettings.Resolution == "1080i_5994" || cameraSettings.Resolution == "1080i_50") {
            document.getElementById("outputSourceSelect").disabled = true;
            $("#outputSourceSelect").val("hdmi+stream");
        } else {
            if (supportUVC) {
                document.getElementById("outputSourceSelect").disabled = false;
            } else {
                document.getElementById("outputSourceSelect").disabled = true;
            }
        }
    }
}

function updateResolution() {
    if (cameraSettings.ModelName == "CV730-HN" || cameraSettings.ModelName == "VC-A71P-HN") {
        updateResolution_4K_LDC_off();
    } else {
        updateResolution_4K_LDC_on(1);
    }
    if (cameraSettings.Resolution == "2160p_60" || cameraSettings.Resolution == "2160p_5994" || cameraSettings.Resolution == "2160p_50") {
        if (document.getElementById("hdmiFormatSelect").options[1].value != "yuv420") {
            updateHdmiFormatSelect();
            $("#hdmiFormatSelect").val("yuv420");
        }
    } else {
        if (document.getElementById("hdmiFormatSelect").options[1].value == "yuv420") {
            $("#hdmiFormatSelect option[value='yuv420']").remove();
        }
    }
    updateOutputSource();
}

function updateOutputSource() {
    if (document.getElementById("outputSourceSelect").value == "stream") {
        document.getElementById("hdmiFormatSelect").disabled = true;
    } else {
        document.getElementById("hdmiFormatSelect").disabled = false;
    }
    updateUVC();
}

function updateUVCFrameRateSelect() {
    var resolution = $("#resolutionSelect").val();
    $("#uvcFrameRateSelect").empty();
    if (resolution.indexOf("_60") >= 0) {
        $("#uvcFrameRateSelect").append($("<option></option>").val("60").text("60"));
        $("#uvcFrameRateSelect").append($("<option></option>").val("30").text("30"));
    } else if (resolution.indexOf("5994") >= 0) {
        $("#uvcFrameRateSelect").append($("<option></option>").val("59.94").text("59.94"));
        $("#uvcFrameRateSelect").append($("<option></option>").val("29.97").text("29.97"));
    } else if (resolution.indexOf("50") >= 0) {
        $("#uvcFrameRateSelect").append($("<option></option>").val("50").text("50"));
        $("#uvcFrameRateSelect").append($("<option></option>").val("25").text("25"));
    } else if (resolution.indexOf("_30") >= 0) {
        $("#uvcFrameRateSelect").append($("<option></option>").val("30").text("30"));
    } else if (resolution.indexOf("2997") >= 0) {
        $("#uvcFrameRateSelect").append($("<option></option>").val("29.97").text("29.97"));
    } else {
        $("#uvcFrameRateSelect").append($("<option></option>").val("25").text("25"));
    }
}

function updateUVC() {
    var outputSource = $("#outputSourceSelect").val();
    var resolution = $("#resolutionSelect").val();
    if (outputSource == "hdmi+uvc") {
        if (resolution.indexOf("2160p") >= 0) {
            $("#uvcCodecLabel").text("H.264");
        } else {
            $("#uvcCodecLabel").text("H.264/MJPEG");
        }
        document.getElementById("uvcFrameRateSelect").disabled = false;
    } else {
        $("#uvcCodecLabel").text("Off");
        document.getElementById("uvcFrameRateSelect").disabled = true;
    }
    if (resolution.indexOf("2160p") >= 0) {
        $("#uvcResolutionLabel").text("4k");
    } else if (resolution.indexOf("1080") >= 0) {
        $("#uvcResolutionLabel").text("1080P");
    } else {
        $("#uvcResolutionLabel").text("720P");
    }
    updateUVCFrameRateSelect();
}

function updateOutputPageSelect() {
    var support_60_30 = 0;
    var support_4K_59 = 1;
    var support_4K_29 = 1;

    if (cameraSettings.ModelName == "CV420e") {
        support_60_30 = 1;
    }

    if (support_4K_59 && support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("2160p_60").text("3840x2160/60p"));
    }
    if (support_4K_59) {
        $("#resolutionSelect").append($("<option></option>").val("2160p_5994").text("3840x2160/59.94p"));
        $("#resolutionSelect").append($("<option></option>").val("2160p_50").text("3840x2160/50p"));
    }

    if (support_4K_29 && support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("2160p_30").text("3840x2160/30p"));
    }
    if (support_4K_29) {
        $("#resolutionSelect").append($("<option></option>").val("2160p_2997").text("3840x2160/29.97p"));
        $("#resolutionSelect").append($("<option></option>").val("2160p_25").text("3840x2160/25p"));
    }

    if (support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("1080p_60").text("1080p/60"));
    }
    $("#resolutionSelect").append($("<option></option>").val("1080p_5994").text("1080p/59.94"));
    $("#resolutionSelect").append($("<option></option>").val("1080p_50").text("1080p/50"));

    if (support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("1080p_30").text("1080p/30"));
    }
    $("#resolutionSelect").append($("<option></option>").val("1080p_2997").text("1080p/29.97"));
    $("#resolutionSelect").append($("<option></option>").val("1080p_25").text("1080p/25"));

    if (support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("720p_60").text("720p/60"));
    }
    $("#resolutionSelect").append($("<option></option>").val("720p_5994").text("720p/59.94"));
    $("#resolutionSelect").append($("<option></option>").val("720p_50").text("720p/50"));

    if (support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("720p_30").text("720p/30"));
    }
    $("#resolutionSelect").append($("<option></option>").val("720p_2997").text("720p/29.97"));
    $("#resolutionSelect").append($("<option></option>").val("720p_25").text("720p/25"));

    if (support_60_30) {
        $("#resolutionSelect").append($("<option></option>").val("1080i_60").text("1080i/60"));
    }
    $("#resolutionSelect").append($("<option></option>").val("1080i_5994").text("1080i/59.94"));
    $("#resolutionSelect").append($("<option></option>").val("1080i_50").text("1080i/50"));

    updateOutputSourceSelect();
    updateHdmiFormatSelect();

    $("#overlayTopLeftModeSelect").append($("<option></option>").val("off").text("Off"));
    $("#overlayTopLeftModeSelect").append($("<option></option>").val("daytime").text("Date And Time"));
    $("#overlayTopLeftModeSelect").append($("<option></option>").val("text").text("Text"));
    $("#overlayTopRightModeSelect").append($("<option></option>").val("off").text("Off"));
    $("#overlayTopRightModeSelect").append($("<option></option>").val("daytime").text("Date And Time"));
    $("#overlayTopRightModeSelect").append($("<option></option>").val("text").text("Text"));
}

function updateOutputPageValue() {
    $("#resolutionSelect").val(cameraSettings.Resolution);
    updateResolution();
    $("#outputSourceSelect").val(cameraSettings.OutputSource);
    updateOutputSource();
    $("#hdmiFormatSelect").val(cameraSettings.HdmiColor);
    updateUVC();
    $("#uvcFrameRateSelect").val(cameraSettings.UVCFrameRate);
    $("#overlayTopLeftModeSelect").val(cameraSettings.OverlayTopLeftMode);
    $("#overlayTopLeftTextInput").val(cameraSettings.OverlayTopLeftText);
    $("#overlayTopRightModeSelect").val(cameraSettings.OverlayTopRightMode);
    $("#overlayTopRightTextInput").val(cameraSettings.OverlayTopRightText);
}

function saveOutputSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/camera.cgi?";

    cgiParam.Resolution = $("#resolutionSelect").val();
    cgiParam.OutputSource = $("#outputSourceSelect").val();
    cgiParam.HdmiColor = $("#hdmiFormatSelect").val();
    cgiParam.OverlayTopLeftMode = $("#overlayTopLeftModeSelect").val();
    cgiParam.OverlayTopLeftText = $("#overlayTopLeftTextInput").val();
    cgiParam.OverlayTopRightMode = $("#overlayTopRightModeSelect").val();
    cgiParam.OverlayTopRightText = $("#overlayTopRightTextInput").val();
    cgiParam.UVCFrameRate = $("#uvcFrameRateSelect").val();
    AddParameter("Resolution", cgiParam.Resolution);
    AddParameter("OutputSource", cgiParam.OutputSource);
    AddParameter("HdmiColor", cgiParam.HdmiColor);
    AddParameter("OverlayTopLeftMode", cgiParam.OverlayTopLeftMode);
    AddParameter("OverlayTopLeftText", cgiParam.OverlayTopLeftText);
    AddParameter("OverlayTopRightMode", cgiParam.OverlayTopRightMode);
    AddParameter("OverlayTopRightText", cgiParam.OverlayTopRightText);
    if (cgiParam.OutputSource == "hdmi+uvc")
        AddParameter("UVCFrameRate", cgiParam.UVCFrameRate);

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Output Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Output settings saved to " + cameraSettings.CameraName);
            reloadOutput();
            UnblockUIforPage();
        }
    });
}

function reloadOutput() {
    openOutput();
}

function updateOverlayTopLeft() {
    if ($("#overlayTopLeftModeSelect").val() == "text") {
        $("#overlayTopLeftTextInput").show();
    } else {
        $("#overlayTopLeftTextInput").hide();
    }
}

function updateOverlayTopRight() {
    if ($("#overlayTopRightModeSelect").val() == "text") {
        $("#overlayTopRightTextInput").show();
    } else {
        $("#overlayTopRightTextInput").hide();
    }
}

function openOutput() {
    $("#DivMainPage").load("./page/output.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        if (cameraSettings.ViewerMode != 0) {
            $(".mainTable").hide();
            $(".UVC_label").hide();
            $(".Overlay_Table").show();
        }
        $.ajax({
            url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system&inqjs=camera&inqjs=ndi",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                updateOutputPageSelect();
                updateOutputPageValue();
                updateOverlayTopLeft();
                updateOverlayTopRight();

                $("#resolutionSelect").change(function () {
                    updateResolution();
                });
                $("#outputSourceSelect").change(function () {
                    updateOutputSource();
                });
                $("#overlayTopLeftModeSelect").change(function () {
                    updateOverlayTopLeft();
                });
                $("#overlayTopRightModeSelect").change(function () {
                    updateOverlayTopRight();
                });
                $("#applyButton").on('click', saveOutputSettings);
                $("#cancelButton").on('click', reloadOutput);
            }
        });
    });
}
